definition module EdProjectUtils;

import EdTypes, EdProgramState, EdProject;

::	Compiled_and_Linked	:== Bool;

::	SetMadeProjectFun
	:== Bool -> Bool -> Project -> ProgState -> *(IO -> ProgIO);
	// The continuation function for the MakeProject function:
	// arguments:	- boolean indicating whether compilation/code generation linking has been
	//				  performed
	//				- boolean indicating whether 'make' was successfull
	//				- the new project 

/*	Compiles a project module.
	1st arg.	Check syntax only?
	2nd arg.	Full .icl path name of the module to be compiled.
	3rd arg.	The (temporary) project to which the module belongs.
	4th arg.	Continuation function which will set the new project, update various windows etc.
	5th arg.	The program state.
	6th arg.	The io state.
	result		The new program and io state.
*/
CompileProjectModule ::	!CompileOrCheckSyntax !Pathname !Project !SetMadeProjectFun !ProgState !IO
						-> ProgIO;
						
/*	Compiles and generated code for a project module.
	1st arg.	Generate assembly only?
	2nd arg.	Full .icl path name of the module to be compiled.
	3rd arg.	The (temporary) project to which the module belongs.
	4th arg.	Continuation function which will set the new project, update various windows etc.
	5th arg.	The program state.
	6th arg.	The io state.
	result		The new program and io state.
*/
CompileAndGenCodeProjectModule ::	!CodeGenerateAsmOrCode !Pathname !Project !SetMadeProjectFun !ProgState !IO
									-> ProgIO;

/*	Brings the project up to date.
	1st arg.	The project which must be brought up to date.
	2nd arg.	Continuation function which will set the new project, update various windows etc.
	3rd arg.	The program state.
	4th arg.	The io state.
	result		The new program and io state.
*/
MakeProject :: !Project !SetMadeProjectFun !ProgState !IO -> ProgIO;

UpdateCompilerOptionsWithABCOptions :: CompilerOptions ABCOptions -> CompilerOptions;
